!Object constantsFor: 'Geos Libraries'!

geosLIB58 'SYSTEM\ruler'! !

!Object constantsFor: 'Geos vardata'!

!

!Object constantsFor: 'Geos messages'!

rulerGainedSelection 18432!
rulerLostSelection 18433!
rulerUpdateControllers 18434!
rulerUpdateTypeController 18435!
rulerUpdateGridController 18436!
rulerUpdateGuideController 18437!
rulerCombineGuideInfo 18438!
rulerRuleLargePtr 18439!
rulerSetType 18440!
rulerGetType 18441!
rulerGetConstrainStrategy 18442!
rulerSetConstrainStrategy 18443!
rulerSetIgnoreOrigin 18444!
rulerShowMouse 18445!
rulerHideMouse 18446!
rulerDrawMouseTick 18447!
rulerTurnGridSnappingOn 18448!
rulerTurnGridSnappingOff 18449!
rulerTurnGuidesSnappingOn 18450!
rulerTurnGuidesSnappingOff 18451!
rulerSetMinIncrement 18452!
rulerViewScaleFactorChanged 18453!
rulerSetScale 18454!
rulerSetGridSpacing 18455!
rulerSetHorizontalGridSpacing 18456!
rulerSetVerticalGridSpacing 18457!
rulerDrawGrid 18458!
rulerSnapToGrid 18459!
rulerSnapToGridX 18460!
rulerSnapToGridY 18461!
rulerSetReference 18462!
rulerSnapRelativeToReference 18463!
rulerSnapRelativeToReferenceX 18464!
rulerSnapRelativeToReferenceY 18465!
rulerGetGridSpacing 18466!
rulerGetStrategicGridSpacing 18467!
rulerCreateGuideArray 18468!
rulerAddHorizontalGuide 18469!
rulerAddVerticalGuide 18470!
rulerDrawGuides 18471!
rulerDrawGuideIndicators 18472!
rulerSnapToGuides 18473!
rulerSnapToGuidesX 18474!
rulerSnapToGuidesY 18475!
rulerConstrainToAxes 18476!
rulerConstrainToHorizontalAxis 18477!
rulerConstrainToVerticalAxis 18478!
rulerConstrainToDiagonals 18479!
rulerConstrainXToUnitySlopeAxis 18480!
rulerConstrainYToUnitySlopeAxis 18481!
rulerConstrainXToNegativeUnitySlopeAxis 18482!
rulerConstrainYToNegativeUnitySlopeAxis 18483!
rulerSetOrigin 18484!
rulerGetOrigin 18485!
rulerSetVector 18486!
rulerConstrainToVector 18487!
rulerConstrainXToVector 18488!
rulerConstrainYToVector 18489!
rulerConstrainXToVectorReflection 18490!
rulerConstrainYToVectorReflection 18491!
rulerGetDesiredSize 18492!
rulerGetGuideInfluence 18493!
rulerSetGuideInfluence 18494!
rulerSelectHorizontalGuide 18495!
rulerSelectVerticalGuide 18496!
rulerDeselectAllHorizontalGuides 18497!
rulerDeselectAllVerticalGuides 18498!
rulerDeleteHorizontalGuide 18499!
rulerDeleteVerticalGuide 18500!
rulerShowGrid 18501!
rulerHideGrid 18502!
rulerInvalidateWithSlaves 18503!
rulerSetConstrainTransform 18504!
rulerClearConstrainTransform 18505!
createVerticalGuideline 27648!
createHorizontalGuideline 27649!
setGridSpacing 27648!
setGridOptions 27649!
selectGuide 27648!
queryGuide 27649!
deleteGuide 27650!
updateUi 27651!
changeState 27648!
typeChange 27648!
!

!Geos class methodsFor: 'library calls'!

RulerScaleDocToWinCoords: pself with: point
	"void pascal RulerScaleDocToWinCoords(VisRulerInstance* pself, DWFixed* point) in ruler.goh"
	^GEOS call: pself with: point with: #[58 0 10 3 3 0]!

RulerScaleWinToDocCoords: pself with: point
	"void pascal RulerScaleWinToDocCoords(VisRulerInstance* pself, DWFixed* point) in ruler.goh"
	^GEOS call: pself with: point with: #[58 0 11 3 3 0]!

!

Vis subclass: #VisRuler
	instanceVariableNames: ''
	classVariableNames: ''!

VisContent subclass: #RulerContent
	instanceVariableNames: ''
	classVariableNames: ''!

GenView subclass: #RulerView
	instanceVariableNames: ''
	classVariableNames: ''!

GenControl subclass: #GuideCreateControl
	instanceVariableNames: ''
	classVariableNames: ''!

GenControl subclass: #RulerGridControl
	instanceVariableNames: ''
	classVariableNames: ''!

GenControl subclass: #RulerGuideControl
	instanceVariableNames: ''
	classVariableNames: ''!

GenControl subclass: #RulerShowControl
	instanceVariableNames: ''
	classVariableNames: ''!

GenControl subclass: #RulerTypeControl
	instanceVariableNames: ''
	classVariableNames: ''!

!VisRuler comment!
Library ruler, file ruler.goh! !

!VisRuler class methodsFor: 'library linkage'!

library
	^58!

entry
	^0!
!

!VisRuler methodsFor: 'Geos instance variables'!

vriRulerAttrs
	"@instance VisRulerAttributes VRI_rulerAttrs"
	^self byteAt: 17!

vriRulerAttrs: value
	"@instance VisRulerAttributes VRI_rulerAttrs"
	^self byteAt: 17 put: value!

vriType
	"@instance VisRulerType VRI_type"
	^self byteAt: 18!

vriType: value
	"@instance VisRulerType VRI_type"
	^self byteAt: 18 put: value!

vriConstrainStrategy
	"@instance VisRulerConstrainStrategy VRI_constrainStrategy"
	^self wordAt: 19!

vriConstrainStrategy: value
	"@instance VisRulerConstrainStrategy VRI_constrainStrategy"
	^self wordAt: 19 put: value!

vriMinIncrement
	"@instance MinIncrementType VRI_minIncrement"
	^self byteAt: 21!

vriMinIncrement: value
	"@instance MinIncrementType VRI_minIncrement"
	^self byteAt: 21 put: value!

vriScale
	"@instance WWFixed VRI_scale"
	^GCSWWFixed forPointer: (self ptrAt: 22).!

vriScale: aBlock
	"@instance WWFixed VRI_scale"
	aBlock value: (GCSWWFixed forPointer: (self ptrAt: 22)).!

vriOrigin
	"@instance DWFixed VRI_origin"
	^GCSDWFixed forPointer: (self ptrAt: 26).!

vriOrigin: aBlock
	"@instance DWFixed VRI_origin"
	aBlock value: (GCSDWFixed forPointer: (self ptrAt: 26)).!

vriReference
	"@instance PointDWFixed VRI_reference"
	^GCSPointDWFixed forPointer: (self ptrAt: 32).!

vriReference: aBlock
	"@instance PointDWFixed VRI_reference"
	aBlock value: (GCSPointDWFixed forPointer: (self ptrAt: 32)).!

vriMouseMark
	"@instance sdword VRI_mouseMark"
	^self dwordAt: 44!

vriMouseMark: value
	"@instance sdword VRI_mouseMark"
	^self dwordAt: 44 put: value!

vriWindow
	"@instance word VRI_window"
	^self wordAt: 48!

vriWindow: value
	"@instance word VRI_window"
	^self wordAt: 48 put: value!

vriSlave
	"@instance optr VRI_slave"
	^self dwordAt: 50!

vriSlave: value
	"@instance optr VRI_slave"
	^self dwordAt: 50 put: value!

vriGrid
	"@instance Grid VRI_grid"
	^GCSGrid forPointer: (self ptrAt: 54).!

vriGrid: aBlock
	"@instance Grid VRI_grid"
	aBlock value: (GCSGrid forPointer: (self ptrAt: 54)).!

vriVectorSlope
	"@instance WWFixed VRI_vectorSlope"
	^GCSWWFixed forPointer: (self ptrAt: 62).!

vriVectorSlope: aBlock
	"@instance WWFixed VRI_vectorSlope"
	aBlock value: (GCSWWFixed forPointer: (self ptrAt: 62)).!

vriGuideArray
	"@instance optr VRI_guideArray"
	^self dwordAt: 66!

vriGuideArray: value
	"@instance optr VRI_guideArray"
	^self dwordAt: 66 put: value!

vriGuideInfluence
	"@instance word VRI_guideInfluence"
	^self wordAt: 70!

vriGuideInfluence: value
	"@instance word VRI_guideInfluence"
	^self wordAt: 70 put: value!

vriDesiredSize
	"@instance word VRI_desiredSize"
	^self wordAt: 72!

vriDesiredSize: value
	"@instance word VRI_desiredSize"
	^self wordAt: 72 put: value!

vriReserved
	"@instance word VRI_reserved"
	^self wordAt: 74!

vriReserved: value
	"@instance word VRI_reserved"
	^self wordAt: 74 put: value!

vriInvalOD
	"@instance dword VRI_invalOD"
	^self dwordAt: 76!

vriInvalOD: value
	"@instance dword VRI_invalOD"
	^self dwordAt: 76 put: value!

vriTransformGState
	"@instance word VRI_transformGState"
	^self wordAt: 80!

vriTransformGState: value
	"@instance word VRI_transformGState"
	^self wordAt: 80 put: value!

!

!VisRuler methodsFor: 'Geos vardata'!

!

!VisRuler methodsFor: 'Geos messages'!

rulerGainedSelection: dest
	"@message void MSG_VIS_RULER_GAINED_SELECTION(optr dest = cx:dx)"
	^self geosMessage: #[72 0 2 53 2 0] with: dest!

rulerLostSelection
	"@message void MSG_VIS_RULER_LOST_SELECTION()"
	^self geosMessage: #[72 1 2 0 0]!

rulerUpdateControllers
	"@message void MSG_VIS_RULER_UPDATE_CONTROLLERS()"
	^self geosMessage: #[72 2 2 0 0]!

rulerUpdateTypeController
	"@message void MSG_VIS_RULER_UPDATE_TYPE_CONTROLLER()"
	^self geosMessage: #[72 3 2 0 0]!

rulerUpdateGridController
	"@message void MSG_VIS_RULER_UPDATE_GRID_CONTROLLER()"
	^self geosMessage: #[72 4 2 0 0]!

rulerUpdateGuideController
	"@message void MSG_VIS_RULER_UPDATE_GUIDE_CONTROLLER()"
	^self geosMessage: #[72 5 2 0 0]!

rulerCombineGuideInfo: data
	"@message void MSG_VIS_RULER_COMBINE_GUIDE_INFO(MemHandle data = cx)"
	^self geosMessage: #[72 6 2 5 1 0] with: data!

rulerRuleLargePtr
	"@message void MSG_VIS_RULER_RULE_LARGE_PTR()"
	^self geosMessage: #[72 7 2 0 0]!

rulerSetType: type
	"@message void MSG_VIS_RULER_SET_TYPE(VisRulerType type = cl)"
	^self geosMessage: #[72 8 2 1 1 0] with: type!

rulerGetType
	"@message VisRulerType MSG_VIS_RULER_GET_TYPE()= cl"
	^self geosMessage: #[72 9 74 0 1]!

rulerGetConstrainStrategy
	"@message VisRulerConstrainStrategy MSG_VIS_RULER_GET_CONSTRAIN_STRATEGY()= cx"
	^self geosMessage: #[72 10 102 0 1]!

rulerSetConstrainStrategy: setflags with: clearflags
	"@message void MSG_VIS_RULER_SET_CONSTRAIN_STRATEGY(VisRulerConstrainStrategy setflags = cx, VisRulerConstrainStrategy clearflags = dx)"
	^self geosMessage: #[72 11 2 53 1 1 0] with: setflags with: clearflags!

rulerSetIgnoreOrigin: ignore
	"@message void MSG_VIS_RULER_SET_IGNORE_ORIGIN(Boolean ignore = cx)"
	^self geosMessage: #[72 12 2 5 4 0] with: ignore!

rulerShowMouse
	"@message void MSG_VIS_RULER_SHOW_MOUSE()"
	^self geosMessage: #[72 13 2 0 0]!

rulerHideMouse
	"@message void MSG_VIS_RULER_HIDE_MOUSE()"
	^self geosMessage: #[72 14 2 0 0]!

rulerDrawMouseTick: yInt with: yFrac with: xInt with: xFrac
	"@message void MSG_VIS_RULER_DRAW_MOUSE_TICK(@stack sdword yInt, word yFrac, sdword xInt, word xFrac)"
	^self geosMessage: #[72 15 0 12 2 1 2 1 0] with: yInt with: yFrac with: xInt with: xFrac!

rulerTurnGridSnappingOn
	"@message void MSG_VIS_RULER_TURN_GRID_SNAPPING_ON()"
	^self geosMessage: #[72 16 2 0 0]!

rulerTurnGridSnappingOff
	"@message void MSG_VIS_RULER_TURN_GRID_SNAPPING_OFF()"
	^self geosMessage: #[72 17 2 0 0]!

rulerTurnGuidesSnappingOn
	"@message void MSG_VIS_RULER_TURN_GUIDES_SNAPPING_ON()"
	^self geosMessage: #[72 18 2 0 0]!

rulerTurnGuidesSnappingOff
	"@message void MSG_VIS_RULER_TURN_GUIDES_SNAPPING_OFF()"
	^self geosMessage: #[72 19 2 0 0]!

rulerSetMinIncrement: min
	"@message void MSG_VIS_RULER_SET_MIN_INCREMENT(MinIncrementType min = cl)"
	^self geosMessage: #[72 20 2 1 1 0] with: min!

rulerViewScaleFactorChanged: viewWindow with: yScaleFactor with: xScaleFactor
	"@message void MSG_VIS_RULER_VIEW_SCALE_FACTOR_CHANGED(@stack WindowHandle viewWindow, WWFixedAsDWord yScaleFactor, WWFixedAsDWord xScaleFactor)"
	^self geosMessage: #[72 21 0 10 1 2 2 0] with: viewWindow with: yScaleFactor with: xScaleFactor!

rulerSetScale: scale
	"@message void MSG_VIS_RULER_SET_SCALE(WWFixedAsDWord scale = dx.cx)"
	^self geosMessage: #[72 22 2 46 2 0] with: scale!

rulerSetGridSpacing: spacing
	"@message void MSG_VIS_RULER_SET_GRID_SPACING(WWFixedAsDWord spacing = dx.cx)"
	^self geosMessage: #[72 23 2 46 2 0] with: spacing!

rulerSetHorizontalGridSpacing: spacing
	"@message void MSG_VIS_RULER_SET_HORIZONTAL_GRID_SPACING(WWFixedAsDWord spacing = dx.cx)"
	^self geosMessage: #[72 24 2 46 2 0] with: spacing!

rulerSetVerticalGridSpacing: spacing
	"@message void MSG_VIS_RULER_SET_VERTICAL_GRID_SPACING(WWFixedAsDWord spacing = dx.cx)"
	^self geosMessage: #[72 25 2 46 2 0] with: spacing!

rulerDrawGrid: gstate
	"@message void MSG_VIS_RULER_DRAW_GRID(GStateHandle gstate = bp)"
	^self geosMessage: #[72 26 2 7 1 0] with: gstate!

rulerSnapToGrid: point
	"@message void MSG_VIS_RULER_SNAP_TO_GRID(PointDWFixed * point=ss:bp)"
	^self geosMessage: #[72 27 0 128 3 0] with: point!

rulerSnapToGridX: point
	"@message void MSG_VIS_RULER_SNAP_TO_GRID_X(PointDWFixed * point=ss:bp)"
	^self geosMessage: #[72 28 0 128 3 0] with: point!

rulerSnapToGridY: point
	"@message void MSG_VIS_RULER_SNAP_TO_GRID_Y(PointDWFixed * point=ss:bp)"
	^self geosMessage: #[72 29 0 128 3 0] with: point!

rulerSetReference: yInt with: yFrac with: xInt with: xFrac
	"@message void MSG_VIS_RULER_SET_REFERENCE(@stack sdword yInt, word yFrac, sdword xInt, word xFrac)"
	^self geosMessage: #[72 30 0 12 2 1 2 1 0] with: yInt with: yFrac with: xInt with: xFrac!

rulerSnapRelativeToReference: point
	"@message void MSG_VIS_RULER_SNAP_RELATIVE_TO_REFERENCE(PointDWFixed * point=ss:bp)"
	^self geosMessage: #[72 31 0 128 3 0] with: point!

rulerSnapRelativeToReferenceX: point
	"@message void MSG_VIS_RULER_SNAP_RELATIVE_TO_REFERENCE_X(PointDWFixed * point=ss:bp)"
	^self geosMessage: #[72 32 0 128 3 0] with: point!

rulerSnapRelativeToReferenceY: point
	"@message void MSG_VIS_RULER_SNAP_RELATIVE_TO_REFERENCE_Y(PointDWFixed * point=ss:bp)"
	^self geosMessage: #[72 33 0 128 3 0] with: point!

rulerGetGridSpacing: gridspace
	"@message void MSG_VIS_RULER_GET_GRID_SPACING(GridSpacing* gridspace = axbpcxdx)"
	^self geosMessage: #[72 34 194 0 3 0] with: gridspace!

rulerGetStrategicGridSpacing: gridspace
	"@message void MSG_VIS_RULER_GET_STRATEGIC_GRID_SPACING(GridSpacing* gridspace = axbpcxdx)"
	^self geosMessage: #[72 35 194 0 3 0] with: gridspace!

rulerCreateGuideArray
	"@message void MSG_VIS_RULER_CREATE_GUIDE_ARRAY()"
	^self geosMessage: #[72 36 2 0 0]!

rulerAddHorizontalGuide: dwfInt with: dwfFrac
	"@message void MSG_VIS_RULER_ADD_HORIZONTAL_GUIDE(@stack sdword dwfInt, word dwfFrac)"
	^self geosMessage: #[72 37 0 6 2 1 0] with: dwfInt with: dwfFrac!

rulerAddVerticalGuide: dwfInt with: dwfFrac
	"@message void MSG_VIS_RULER_ADD_VERTICAL_GUIDE(@stack sdword dwfInt, word dwfFrac)"
	^self geosMessage: #[72 38 0 6 2 1 0] with: dwfInt with: dwfFrac!

rulerDrawGuides: gstate
	"@message void MSG_VIS_RULER_DRAW_GUIDES(GStateHandle gstate = bp)"
	^self geosMessage: #[72 39 2 7 1 0] with: gstate!

rulerDrawGuideIndicators
	"@message void MSG_VIS_RULER_DRAW_GUIDE_INDICATORS()"
	^self geosMessage: #[72 40 2 0 0]!

rulerSnapToGuides: point
	"@message void MSG_VIS_RULER_SNAP_TO_GUIDES(PointDWFixed * point=ss:bp)"
	^self geosMessage: #[72 41 0 128 3 0] with: point!

rulerSnapToGuidesX: point
	"@message void MSG_VIS_RULER_SNAP_TO_GUIDES_X(PointDWFixed * point=ss:bp)"
	^self geosMessage: #[72 42 0 128 3 0] with: point!

rulerSnapToGuidesY: point
	"@message void MSG_VIS_RULER_SNAP_TO_GUIDES_Y(PointDWFixed * point=ss:bp)"
	^self geosMessage: #[72 43 0 128 3 0] with: point!

rulerConstrainToAxes: point
	"@message void MSG_VIS_RULER_CONSTRAIN_TO_AXES(PointDWFixed * point=ss:bp)"
	^self geosMessage: #[72 44 0 128 3 0] with: point!

rulerConstrainToHorizontalAxis: point
	"@message void MSG_VIS_RULER_CONSTRAIN_TO_HORIZONTAL_AXIS(PointDWFixed * point=ss:bp)"
	^self geosMessage: #[72 45 0 128 3 0] with: point!

rulerConstrainToVerticalAxis: point
	"@message void MSG_VIS_RULER_CONSTRAIN_TO_VERTICAL_AXIS(PointDWFixed * point=ss:bp)"
	^self geosMessage: #[72 46 0 128 3 0] with: point!

rulerConstrainToDiagonals: point
	"@message void MSG_VIS_RULER_CONSTRAIN_TO_DIAGONALS(PointDWFixed * point=ss:bp)"
	^self geosMessage: #[72 47 0 128 3 0] with: point!

rulerConstrainXToUnitySlopeAxis: point
	"@message void MSG_VIS_RULER_CONSTRAIN_X_TO_UNITY_SLOPE_AXIS(PointDWFixed * point=ss:bp)"
	^self geosMessage: #[72 48 0 128 3 0] with: point!

rulerConstrainYToUnitySlopeAxis: point
	"@message void MSG_VIS_RULER_CONSTRAIN_Y_TO_UNITY_SLOPE_AXIS(PointDWFixed * point=ss:bp)"
	^self geosMessage: #[72 49 0 128 3 0] with: point!

rulerConstrainXToNegativeUnitySlopeAxis: point
	"@message void MSG_VIS_RULER_CONSTRAIN_X_TO_NEGATIVE_UNITY_SLOPE_AXIS(PointDWFixed * point=ss:bp)"
	^self geosMessage: #[72 50 0 128 3 0] with: point!

rulerConstrainYToNegativeUnitySlopeAxis: point
	"@message void MSG_VIS_RULER_CONSTRAIN_Y_TO_NEGATIVE_UNITY_SLOPE_AXIS(PointDWFixed * point=ss:bp)"
	^self geosMessage: #[72 51 0 128 3 0] with: point!

rulerSetOrigin: pointInt with: pointFrac
	"@message void MSG_VIS_RULER_SET_ORIGIN(sdword pointInt = dx:cx, word pointFrac = bp)"
	^self geosMessage: #[72 52 3 238 2 1 0] with: pointInt with: pointFrac!

rulerGetOrigin: retval
	"@message void MSG_VIS_RULER_GET_ORIGIN(DWFixedReturn *retval = axbpcxdx)"
	^self geosMessage: #[72 53 194 0 3 0] with: retval!

rulerSetVector: yInt with: yFrac with: xInt with: xFrac
	"@message void MSG_VIS_RULER_SET_VECTOR(@stack sdword yInt, word yFrac, sdword xInt, word xFrac)"
	^self geosMessage: #[72 54 0 12 2 1 2 1 0] with: yInt with: yFrac with: xInt with: xFrac!

rulerConstrainToVector: point
	"@message void MSG_VIS_RULER_CONSTRAIN_TO_VECTOR(PointDWFixed * point=ss:bp)"
	^self geosMessage: #[72 55 0 128 3 0] with: point!

rulerConstrainXToVector: point
	"@message void MSG_VIS_RULER_CONSTRAIN_X_TO_VECTOR(PointDWFixed * point=ss:bp)"
	^self geosMessage: #[72 56 0 128 3 0] with: point!

rulerConstrainYToVector: point
	"@message void MSG_VIS_RULER_CONSTRAIN_Y_TO_VECTOR(PointDWFixed * point=ss:bp)"
	^self geosMessage: #[72 57 0 128 3 0] with: point!

rulerConstrainXToVectorReflection: point
	"@message void MSG_VIS_RULER_CONSTRAIN_X_TO_VECTOR_REFLECTION(PointDWFixed * point=ss:bp)"
	^self geosMessage: #[72 58 0 128 3 0] with: point!

rulerConstrainYToVectorReflection: point
	"@message void MSG_VIS_RULER_CONSTRAIN_Y_TO_VECTOR_REFLECTION(PointDWFixed * point=ss:bp)"
	^self geosMessage: #[72 59 0 128 3 0] with: point!

rulerGetDesiredSize
	"@message word MSG_VIS_RULER_GET_DESIRED_SIZE()= cx"
	^self geosMessage: #[72 60 102 0 1]!

rulerGetGuideInfluence
	"@message word MSG_VIS_RULER_GET_GUIDE_INFLUENCE()= cx"
	^self geosMessage: #[72 61 102 0 1]!

rulerSetGuideInfluence: influence
	"@message void MSG_VIS_RULER_SET_GUIDE_INFLUENCE(word influence=cx)"
	^self geosMessage: #[72 62 2 5 1 0] with: influence!

rulerSelectHorizontalGuide: dwfInt with: dwfFrac
	"@message void MSG_VIS_RULER_SELECT_HORIZONTAL_GUIDE(@stack sdword dwfInt, word dwfFrac)"
	^self geosMessage: #[72 63 0 6 2 1 0] with: dwfInt with: dwfFrac!

rulerSelectVerticalGuide: dwfInt with: dwfFrac
	"@message void MSG_VIS_RULER_SELECT_VERTICAL_GUIDE(@stack sdword dwfInt, word dwfFrac)"
	^self geosMessage: #[72 64 0 6 2 1 0] with: dwfInt with: dwfFrac!

rulerDeselectAllHorizontalGuides
	"@message void MSG_VIS_RULER_DESELECT_ALL_HORIZONTAL_GUIDES()"
	^self geosMessage: #[72 65 2 0 0]!

rulerDeselectAllVerticalGuides
	"@message void MSG_VIS_RULER_DESELECT_ALL_VERTICAL_GUIDES()"
	^self geosMessage: #[72 66 2 0 0]!

rulerDeleteHorizontalGuide: dwfInt with: dwfFrac
	"@message void MSG_VIS_RULER_DELETE_HORIZONTAL_GUIDE(@stack sdword dwfInt, word dwfFrac)"
	^self geosMessage: #[72 67 0 6 2 1 0] with: dwfInt with: dwfFrac!

rulerDeleteVerticalGuide: dwfInt with: dwfFrac
	"@message void MSG_VIS_RULER_DELETE_VERTICAL_GUIDE(@stack sdword dwfInt, word dwfFrac)"
	^self geosMessage: #[72 68 0 6 2 1 0] with: dwfInt with: dwfFrac!

rulerShowGrid
	"@message void MSG_VIS_RULER_SHOW_GRID()"
	^self geosMessage: #[72 69 2 0 0]!

rulerHideGrid
	"@message void MSG_VIS_RULER_HIDE_GRID()"
	^self geosMessage: #[72 70 2 0 0]!

rulerInvalidateWithSlaves
	"@message void MSG_VIS_RULER_INVALIDATE_WITH_SLAVES()"
	^self geosMessage: #[72 71 2 0 0]!

rulerSetConstrainTransform: tm
	"@message void MSG_VIS_RULER_SET_CONSTRAIN_TRANSFORM(TransMatrix* tm = ss:bp)"
	^self geosMessage: #[72 72 0 128 3 0] with: tm!

rulerClearConstrainTransform
	"@message void MSG_VIS_RULER_CLEAR_CONSTRAIN_TRANSFORM()"
	^self geosMessage: #[72 73 2 0 0]!

!

!RulerContent comment!
Library ruler, file ruler.goh! !

!RulerContent class methodsFor: 'library linkage'!

library
	^58!

entry
	^1!
!

!RulerContent methodsFor: 'Geos instance variables'!

!

!RulerContent methodsFor: 'Geos vardata'!

!

!RulerContent methodsFor: 'Geos messages'!

!

!RulerView comment!
Library ruler, file ruler.goh! !

!RulerView class methodsFor: 'library linkage'!

library
	^58!

entry
	^2!
!

!RulerView methodsFor: 'Geos instance variables'!

rviAttrs
	"@instance RulerViewAttributes RVI_attrs"
	^self byteAt: 83!

rviAttrs: value
	"@instance RulerViewAttributes RVI_attrs"
	^self byteAt: 83 put: value!

!

!RulerView methodsFor: 'Geos vardata'!

!

!RulerView methodsFor: 'Geos messages'!

!

!GuideCreateControl comment!
Library ruler, file ruler.goh! !

!GuideCreateControl class methodsFor: 'library linkage'!

library
	^58!

entry
	^4!
!

!GuideCreateControl methodsFor: 'Geos instance variables'!

!

!GuideCreateControl methodsFor: 'Geos vardata'!

!

!GuideCreateControl methodsFor: 'Geos messages'!

createVerticalGuideline
	"@message void MSG_GCC_CREATE_VERTICAL_GUIDELINE()"
	^self geosMessage: #[108 0 2 0 0]!

createHorizontalGuideline
	"@message void MSG_GCC_CREATE_HORIZONTAL_GUIDELINE()"
	^self geosMessage: #[108 1 2 0 0]!

!

!RulerGridControl comment!
Library ruler, file ruler.goh! !

!RulerGridControl class methodsFor: 'library linkage'!

library
	^58!

entry
	^6!
!

!RulerGridControl methodsFor: 'Geos instance variables'!

!

!RulerGridControl methodsFor: 'Geos vardata'!

!

!RulerGridControl methodsFor: 'Geos messages'!

setGridSpacing: points
	"@message void MSG_RGC_SET_GRID_SPACING(WWFixed points = dx.cx)"
	^self geosMessage: #[108 0 2 46 2 0] with: points!

setGridOptions: opts
	"@message void MSG_RGC_SET_GRID_OPTIONS(GridOptions opts = cl)"
	^self geosMessage: #[108 1 2 1 1 0] with: opts!

!

!RulerGuideControl comment!
Library ruler, file ruler.goh! !

!RulerGuideControl class methodsFor: 'library linkage'!

library
	^58!

entry
	^5!
!

!RulerGuideControl methodsFor: 'Geos instance variables'!

rgciDataBlock
	"@instance Handle RGCI_dataBlock"
	^self wordAt: 25!

rgciDataBlock: value
	"@instance Handle RGCI_dataBlock"
	^self wordAt: 25 put: value!

rgciRulerType
	"@instance VisRulerType RGCI_rulerType"
	^self byteAt: 27!

rgciRulerType: value
	"@instance VisRulerType RGCI_rulerType"
	^self byteAt: 27 put: value!

!

!RulerGuideControl methodsFor: 'Geos vardata'!

!

!RulerGuideControl methodsFor: 'Geos messages'!

selectGuide: guideIndex with: stateFlags with: numSelections
	"@message void MSG_RGC_SELECT_GUIDE(word guideIndex = cx, GenItemGroupStateFlags stateFlags = dx, word numSelections = bp)"
	^self geosMessage: #[108 0 3 245 1 1 1 0] with: guideIndex with: stateFlags with: numSelections!

queryGuide: list with: itemNum
	"@message void MSG_RGC_QUERY_GUIDE(optr list = cx:dx, word itemNum = bp)"
	^self geosMessage: #[108 1 3 245 2 1 0] with: list with: itemNum!

deleteGuide
	"@message void MSG_RGC_DELETE_GUIDE()"
	^self geosMessage: #[108 2 2 0 0]!

updateUi: ptr
	"@message void MSG_RGC_UPDATE_UI(GenControlUpdateUIParams *ptr = ss:bp)"
	^self geosMessage: #[108 3 0 128 3 0] with: ptr!

!

!RulerShowControl comment!
Library ruler, file ruler.goh! !

!RulerShowControl class methodsFor: 'library linkage'!

library
	^58!

entry
	^7!
!

!RulerShowControl methodsFor: 'Geos instance variables'!

rsciAttrs
	"@instance RulerShowControlAttributes RSCI_attrs"
	^self wordAt: 25!

rsciAttrs: value
	"@instance RulerShowControlAttributes RSCI_attrs"
	^self wordAt: 25 put: value!

rsciGcnList
	"@instance GCNListType RSCI_gcnList"
	^GCSGCNListType forPointer: (self ptrAt: 27).!

rsciGcnList: aBlock
	"@instance GCNListType RSCI_gcnList"
	aBlock value: (GCSGCNListType forPointer: (self ptrAt: 27)).!

rsciMessage
	"@instance Message RSCI_message"
	^self wordAt: 31!

rsciMessage: value
	"@instance Message RSCI_message"
	^self wordAt: 31 put: value!

!

!RulerShowControl methodsFor: 'Geos vardata'!

!

!RulerShowControl methodsFor: 'Geos messages'!

changeState: flags
	"@message void MSG_RSCC_CHANGE_STATE(RulerShowControlAttributes flags = cx)"
	^self geosMessage: #[108 0 2 5 1 0] with: flags!

!

!RulerTypeControl comment!
Library ruler, file ruler.goh! !

!RulerTypeControl class methodsFor: 'library linkage'!

library
	^58!

entry
	^3!
!

!RulerTypeControl methodsFor: 'Geos instance variables'!

!

!RulerTypeControl methodsFor: 'Geos vardata'!

!

!RulerTypeControl methodsFor: 'Geos messages'!

typeChange: rulerType
	"@message void MSG_RTC_TYPE_CHANGE(VisRulerType rulerType = cl)"
	^self geosMessage: #[108 0 2 1 1 0] with: rulerType!

!

